'
'  This program reads the parameter tables for hard drives 0 and 1.
'
'  Define function and REGISTERS variable type.
'
DECLARE FUNCTION BIN$(N AS LONG)
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,OS AS INTEGER,BYTE AS LONG
'
'  Since interpretation of drive parameter table depends on type of
' computer, find out whether it's an XT or not.
'
INREGS.AX=&HC000
CALL INTERRUPTX(&H15,INREGS,OUTREGS)
DEF SEG=OUTREGS.ES
OS=OUTREGS.BX
MODEL=PEEK(OS+2)
IF MODEL=&HFE OR MODEL=&HFB THEN MODEL=1        '(It's an XT.)
'
'  Get location of table for drive 0 and read table.
'
INREGS.AX=&H3541
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
DEF SEG=OUTREGS.ES
OS=OUTREGS.BX
CLS
PRINT "From Drive 0 Parameter Table:"
PRINT
PRINT
MAXCYL=PEEK(OS)+256*PEEK(OS+1)
PRINT "Maximum # cylinders on drive =";MAXCYL
PRINT
PRINT "Maximum # heads =";PEEK(OS+2)
PRINT
PRECOMP=PEEK(OS+5)+256*PEEK(OS+6) : IF PRECOMP<0 THEN PRECOMP=PRECOMP+65536!
IF PRECOMP<=MAXCYL THEN
PRINT "Starting write pre-compensation cylinder =";PRECOMP
ELSE
PRINT "Pre-compensation write not needed."
END IF
PRINT
BYTE=PEEK(OS+8)
B$=BIN$(BYTE)
IF MODEL=1 THEN
PRINT "Starting cylinder for reduced write current =";PEEK(OS+3)+256*PEEK(OS+4)
PRINT
PRINT "Maximum ECC data burst length =";PEEK(OS+7)
PRINT
BIT7=VAL(MID$(B$,9,1))
IF BIT7=0 THEN PRINT "Retry up to 4 times if problem with disk access."
IF BIT7=1 THEN PRINT "Retries are disabled if problem with disk access."
PRINT
BIT6=VAL(MID$(B$,10,1))
IF BIT6=0 THEN PRINT "Retry enabled when ECC occurs during disk read."
IF BIT6=1 THEN PRINT "Retry diabled when ECC occurs during disk read."
PRINT
DSS=VAL(MID$(B$,14,3))
IF DSS=0 OR DSS>=110 THEN PRINT "Drive step speed = 3 ms"
IF DSS=100 THEN PRINT "Drive step speed = 200 ms"
IF DSS=101 THEN PRINT "Drive step speed = 70 ms (normal)"
PRINT
PRINT
PRINT "Press a key to continue..."
10 IF INKEY$="" THEN GOTO 10
PRINT
PRINT
PRINT "Normal timeout =";PEEK(OS+9);" ms"
PRINT
PRINT "Format drive timeout =";PEEK(OS+10);" ms"
PRINT
PRINT "Check disk drive timeout =";PEEK(OS+11);" ms"
ELSE
RETRY=VAL(MID$(B$,9,2))
IF RETRY=0 THEN PRINT "Retry on error operational."
IF RETRY<>0 THEN PRINT "No retry on error."
PRINT
BIT=VAL(MID$(B$,11,1))
IF BIT=1 THEN
PRINT "Manufacture's defect map is on cylinder ";LTRIM$(RTRIM$(STR$(MAXCYL+1)));
PRINT "."
PRINT
END IF
BIT=VAL(MID$(B$,13,1))
IF BIT=1 THEN
PRINT "There are more than 8 heads."
PRINT
END IF
PRINT "Cylinder for landing zone =";PEEK(OS+12)+256*PEEK(OS+13)
PRINT
PRINT "Sectors per track =";PEEK(OS+14)
END IF
PRINT
PRINT
PRINT "Press a key for drive 1 parameters (or ESC to terminate)."
20 A$=INKEY$ : IF A$="" THEN GOTO 20
IF ASC(A$)<>27 THEN
PRINT
PRINT
'
'  Get location of table for drive 1 and read table.
'
INREGS.AX=&H3546
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
DEF SEG=OUTREGS.ES
OS=OUTREGS.BX
PRINT "From Drive 1 Parameter Table:"
PRINT
PRINT
MAXCYL=PEEK(OS)+256*PEEK(OS+1)
PRINT "Maximum # cylinders on drive =";MAXCYL
PRINT
PRINT "Maximum # heads =";PEEK(OS+2)
PRINT
PRECOMP=PEEK(OS+5)+256*PEEK(OS+6) : IF PRECOMP<0 THEN PRECOMP=PRECOMP+65536!
IF PRECOMP<=MAXCYL THEN
PRINT "Starting write pre-compensation cylinder =";PRECOMP
ELSE
PRINT "Pre-compensation write not needed."
END IF
PRINT
BYTE=PEEK(OS+8)
IF MODEL=1 THEN
PRINT "Starting cylinder for reduced write current =";PEEK(OS+3)+256*PEEK(OS+4)
PRINT
PRINT "maximum ECC data burst length =";PEEK(OS+7)
PRINT
BIT7=VAL(MID$(B$,9,1))
IF BIT7=0 THEN PRINT "Retry up to 4 times if problem with disk access."
IF BIT7=1 THEN PRINT "Retries are disabled if problem with disk access."
PRINT
BIT6=VAL(MID$(B$,10,1))
IF BIT6=0 THEN PRINT "Retry enabled when ECC occurs during disk read."
IF BIT6=1 THEN PRINT "Retry diabled when ECC occurs during disk read."
PRINT
DSS=VAL(MID$(B$,14,3))
IF DSS=0 OR DSS>=110 THEN PRINT "Drive step speed = 3 ms"
IF DSS=100 THEN PRINT "Drive step speed = 200 ms"
IF DSS=101 THEN PRINT "Drive step speed = 70 ms (normal)"
PRINT
PRINT
PRINT "Press a key to continue..."
30 IF INKEY$="" THEN GOTO 30
PRINT
PRINT
PRINT "Normal timeout =";PEEK(OS+9);" ms"
PRINT
PRINT "Format drive timeout =";PEEK(OS+10);" ms"
PRINT
PRINT "Check disk drive timeout =";PEEK(OS+11);" ms"
ELSE
RETRY=VAL(MID$(B$,9,2))
IF RETRY=0 THEN PRINT "Retry on error operational."
IF RETRY<>0 THEN PRINT "No retry on error."
PRINT
BIT=VAL(MID$(B$,11,1))
IF BIT=1 THEN
PRINT "Manufacture's defect map is on cylinder ";LTRIM$(RTRIM$(STR$(MAXCYL+1)));
PRINT "."
PRINT
END IF
BIT=VAL(MID$(B$,13,1))
IF BIT=1 THEN
PRINT "There are more than 8 heads."
PRINT
END IF
PRINT "Cylinder for landing zone =";PEEK(OS+12)+256*PEEK(OS+13)
PRINT
PRINT "Sectors per track =";PEEK(OS+14)
END IF
END IF
END
'
'  This is a "functionized" version of code extracted from a more general
' numeric base conversion program by Robert B. Relf, (C) 1984.  This just
' uses the part of Mr. Relf's code that converts decimal to binary.
'
FUNCTION BIN$(NUM AS LONG)
DIM X AS INTEGER,NUM1 AS LONG
NUM1=NUM : IF NUM1<0 THEN NUM1=NUM1+65536&
BIN1$=""
FOR X=15 TO 0 STEP -1
IF NUM1>=(2^X) THEN
BIN1$=BIN1$+"1"
NUM1=NUM1-(2^X)
ELSE
BIN1$=BIN1$+"0"
END IF
NEXT X
BIN1$=LEFT$(BIN1$,8)+RIGHT$(BIN1$,8)
BIN$=BIN1$
END FUNCTION
